import { AttributeType } from "@aws-sdk/client-cognito-identity-provider";

const INTERNAL__expectedUserIdAttributeKey = 'sub' as const

export function getUserIdFromAttributes(attributes: AttributeType[] | undefined) {
  if (!attributes) {
    return;
  }

  const potentialIdAttribute = attributes.find((a) => a.Name === INTERNAL__expectedUserIdAttributeKey)
  if (!potentialIdAttribute) {
    return;
  }

  return potentialIdAttribute.Value
}
